// Autor: Gustav Matula

#include <cstdio>
#include <cassert>
#include <cstring>

#include <algorithm>
#include <iostream>

using namespace std;
typedef long long llint;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

const int MAXN = 100005;
const int inf = 1 << 30;

int n;
int x[MAXN];
int t[MAXN * 31][2];
int w[MAXN * 31];
int cnt[MAXN * 31];
int id[MAXN * 31];
int alloc = 1;

int best(int i, int j, int len, int val) {
  if (len == 0) return val;

  int ret = inf;
  REP(c, 2) {
    if (!t[i][c]) continue;
    if (t[j][c])
      ret = min(ret, best(t[i][c], t[j][c], len - 1, 2 * val));
    else
      ret = min(ret, best(t[i][c], t[j][c ^ 1], len - 1, 2 * val + 1));
  }

  return ret;
}

llint solve(int i, int len) {
  if (i == 0) return 0;
  w[i] = 1;
  if (len == 0) {
    cnt[i] = 1;
    return 0;
  }

  llint ret = 0;
  REP(c, 2) {
    ret += solve(t[i][c], len - 1);
    w[i] += w[t[i][c]];
    cnt[i] += cnt[t[i][c]];
  }

  int l = t[i][0], r = t[i][1];
  if (w[l] > w[r]) swap(l, r);

  if (w[l] == 0) return ret;
  return ret + best(l, r, len - 1, 1);
}

int main(void) 
{
  scanf("%d", &n);

  memset(id, -1, sizeof id);
  
  REP(i, n) {
    scanf("%d", &x[i]);
    int j = 1;
    for (int bit = 29; bit >= 0; --bit) {
      int c = ((x[i] >> bit) & 1);
      if (!t[j][c]) t[j][c] = ++alloc;
      j = t[j][c];
    }
    id[j] = i;
  }

  llint sol = solve(1, 30);

  REP(i, n) {
    int j = 1;
    bool dira = true;
    for (int bit = 29; bit >= 0; --bit) {
      int c = ((x[i] >> bit) & 1);
      if (!t[j][c] || (dira && cnt[t[j][c]] == 1)) 
	dira = false, j = t[j][!c];
      else 
	j = t[j][c];
    }
    printf("%d%c", id[j] + 1, " \n"[i == n - 1]);
  }

  printf("%lld\n", sol);

  return 0;
}
